;								EJEMPLO 33
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Los mdulos CCPx. Modo PWM. Modulacin de anchura de pulsos.
;
;Consiste en generar una seal de onda cuadrada por la lnea RC2/CCP1 cuyo periodo puede
;ser modificado as como la anchura del pulso (Duty Cycle). El periodo se determina segn la 
;frmula T=(PR2+1)*4*Tosc*TMR2 preescaler. La duracin del pulso o "Duty Cycle" (d) se deter-
;mina segn d=(CCPR1L:CCPCON1<5:4>)*Tosc*TMR2 preescaler.
;
;El ejemplo emplea al mdulo CCP1 con salida de seal por la lnea RC2/CCP1 y un preescaler 
;de 16. La seal de salida tiene un periodo de 3200 uS. La anchura del ciclo "Duty"  es variable
;y, se determina, segn el valor binario de los interruptores del entrenador  (RA5-RA0)

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Temporal		equ	0x20	;Variable temporal

Periodo		equ	.200		;Periodo 3200uS (200*Preescaler de 16*1)

			org	0x00		;Vector de RESET	
			goto	Inicio	
			org	0x05

;Programa principal

Inicio	    clrf	PORTC		;Borra salidas
			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00111111'
			movwf	TRISA		;Puerta A entrada
			movlw	b'11111011'
			movwf	TRISC		;RC2 salida
			movlw	Periodo-1
			movwf	PR2			;Carga el registro de periodos
			bcf		STATUS,RP0	;Selecciona banco 0

;El mdulo CCP1 acta en el modo PWM con salida de seal por RC2/CCP1

		movlw	b'00001100'
		movwf	CCP1CON

;El TMR2 trabaja con un preescaler 1:16 por lo que con una frecuencia de 4MHz evoluciona
;cada 16uS ((4*Tosc)*16)

		movlw	b'00000111'
		movwf	T2CON			;T2 en On

Loop	movf	PORTA,W
		andlw	b'00111111'
		movwf	CCPR1L			;Carga la anchura del pulso (n*8*Prescaler de 16)
		goto	Loop			;Bucle infinito		

		end						;Fin del programa fuente
